/***********************************************
* Xie - THe eXtendable Internet Engine
* File: xie.l
* Purpose: The Bison/Yacc script that generates parse.cpp
* Original Author: Gian Perrone (gian@tritonengineers.com)
* Revised by:
* Please read the LICENCE file
************************************************/

%{

// Includes
#include <malloc.h>  // _alloca is used by the parser
#include <string.h>  // strcpy
#include <stdio.h>
#include <stdlib.h>

//#include "xie.h"
#include "lex.h"     // the lexer
#include "vartab.h"

// Some yacc (bison) defines
#define YYDEBUG 1	      // Generate debug code; needed for YYERROR_VERBOSE
#define YYERROR_VERBOSE // Give a more specific parse error message 

extern int yylex();
extern void set_var(int id, int i, float f, char s[], int type);
extern void init_vartab( void );
extern int insert_var(char * name, int vartype);
extern int find_var_by_name(char * name);
extern char * find_varname_by_id(int id);
extern void print_val(int id);

// Error-reporting function must be defined by the caller
void Error (char *format, ...);

// Forward references
void yyerror (char *msg);
extern int ival;
extern float fval;
extern char * sval;

%}

%token LOOKUP
%token SETINT
%token SETFLT
%token SETSTR
%token PLUS
%token MINUS
%token DIVIDE
%token TIMES
%token MODULO
%token VAR
%token STRING
%token I
%token F
%token CALL
%token FUNC
%token DEFFUNC
%token IF
%token OPN_CS 
%token CLS_CS
%token OPN_PAR
%token CLS_PAR
%token BGN_ARR
%token END_ARR
%token END_STMT		
%token PRINT 
%token ASSIGN
%token EQUAL
%token NEQ
%token LT
%token GT
%token LTEQ
%token GTEQ
%token AND
%token OR
%token INC
%token DEC
%token FOR
%token WHILE
%token ERR_CODE

%%
	test		:	I PLUS I	{ printf("%i\n", $1+$3); }
				;

%%

void Error (char *format, ...)
{
	;
}

// Forward references
void yyerror (char *msg)
{
	//printf("Error!: %s\n", msg); Supressing errors for now, until the parser works better.
}