/***********************************************
* Xie - THe eXtensible Internet Engine
* File: xie.l
* Purpose: The flex/lex script that generates lex.cpp
* Original Author: Gian Perrone (gian@tritonengineers.com)
* Revised by: Anirban Biswas (utpal@cal2.vsnl.net.in)
* Please read the LICENCE file
************************************************/

%{

/* ------------------------------------------------------------------
   Initial code (copied verbatim to the output file)
   ------------------------------------------------------------------ */

// Includes
#include <string.h>   // strcpy, strncpy
#include <io.h>       // isatty
#ifdef MSVC
#define  isatty _isatty  // for some reason isatty is called _isatty in VC..
#endif

#define  _LEX_CPP_   // make sure our variables get created
#include "lex.h"
//#include "vartab.h"

#define YYSTYPE char *
YYSTYPE yylval;

extern "C" int yywrap (); // the yywrap function is declared by the caller
extern int stack_index;
extern int tok[512];
extern int insert_funct(char * name, int rettype);
int temp;
int ival;
float fval;
char * sval;
// Forward references

void ZapComment( void );

//// End of inititial code

#define LOOKUP 258
#define SETINT 259
#define SETFLT 260
#define SETSTR 261
#define PLUS 262
#define MINUS 263
#define DIVIDE 264
#define TIMES 265
#define MODULO 266
#define VAR 267
#define STRING 268
#define I 269
#define F 270
#define CALL 271
#define FUNC 272
#define DEFFUNC 273
#define IF 274
#define OPN_CS 275 
#define CLS_CS 276
#define OPN_PAR 277
#define CLS_PAR 278
#define BGN_ARR 279
#define END_ARR 280
#define END_STMT 281		
#define PRINT 282
#define ASSIGN 283
#define EQUAL 284
#define NEQ 285
#define LT 286
#define GT 287
#define LTEQ 288
#define GTEQ 289
#define AND 290
#define OR 291
#define INC 292
#define DEC 293
#define FOR 294
#define WHILE 295
#define ERR_CODE 296

extern int insert_var(char * name, int vartype);
extern int find_var_by_name(char * name);
%}

DIGIT    [0-9]
STR	   \"[a-z0-9]+\"
FUNCTION   "#"[a-z0-9]+
WSPACE [\t\n ]

%%

[0-9]+		{yylval = yytext; ival=atoi(yytext); return I;}
"set int"	{return SETINT;}
"set float"	{return SETFLT;}
"set str"	{return SETSTR;}
"+"			{return PLUS;}
"-"			{return MINUS;}
"/"			{return DIVIDE;}
"*"			{return TIMES;}
"%"			{return MODULO;}
"$"[a-zA-Z0-9]*               {
     /* A normal word, define it or look it up*/
     if(tok[stack_index] != LOOKUP)    {

           temp = insert_var( yytext, 1);
           printf("The inserted varname is %s\n" , yytext);
           printf("The stored location = %d\n" , temp);
			  return LOOKUP;

     }       else    {

                             temp = find_var_by_name(yytext);
                             printf("IN LOOKUP MODE\n");
                             printf("The location = %d\n" , temp);
     }

   return VAR;
}

"$"[a-zA-Z0-9]*               {
     /* A normal word, define it or look it up*/
     if(tok[stack_index] != LOOKUP)    {

           temp = insert_var( yytext, tok[stack_index]);
           printf("The inserted varname is %s\n" , yytext);
           printf("The stored location = %d\n" , temp);

     }       else    {

                             temp = find_var_by_name(yytext);
                             printf("IN LOOKUP MODE\n");
                             printf("The location = %d\n" , temp);
     }

   return VAR;
}


[0-9]+"."[0-9]+		{yylval = yytext; printf("Float Constant Val: %s\n", yylval); return F;}
"call"		{return CALL;}

{FUNCTION}		{
	if(tok[stack_index] != LOOKUP)    
	{
		temp = insert_funct(yytext, tok[stack_index]);
        printf("The inserted funcname is %s\n" , yytext);
        printf("The stored location = %d\n" , temp);
	}      
								
	else    {

		temp = find_var_by_name(yytext);
        printf("IN LOOKUP MODE\n");
        printf("The location = %d\n" , temp);
	}

	return FUNC;
}

{STR}		{yylval = yytext; printf("Str Constant Val: %s\n", yylval); return STRING;}
"func"		{return DEFFUNC;}
"if"		{return IF;}
"{"			{return OPN_CS;}
"}"			{return CLS_CS;}
"("			{return OPN_PAR;}
")"			{return CLS_PAR;}
"["			{return BGN_ARR;}
"]"			{return END_ARR;}
";"			{return END_STMT;}
"print"		{return PRINT;}
"="			{return ASSIGN;}
"=="		{return EQUAL;}
"!="		{return NEQ;}
"<"			{return LT;}
">"			{return GT;}
"<="		{return LTEQ;}
">="		{return GTEQ;}
"&&"		{return AND;}
"||"		{return OR;}
"++"		{return INC;}
"--"		{return DEC;}
"for"		{return FOR;}
"while"		{return WHILE;}
"//"		{ZapComment();}
{WSPACE}	{ ; }
\n			{lineno++;}
.		    { printf("Unrecognised symbol at line %d\n", lineno); return ERR_CODE;}

%%

void ZapComment( void )
{
	char c;
	while ((c = yyinput()) != '\n' && c != 0);
	lineno++;
}



