/***********************************************
* Xie - THe eXtensible Internet Engine
* File: main.cpp
* Purpose: The main source file
* Original Author: Gian Perrone (gian@tritonengineers.com)
* Revised by: Anirban Biswas (utpal@cal2.vsnl.net.in)
* Please read the LICENCE file
************************************************/

#include <stdio.h>
#include <iostream.h>
#include <string.h>
#include "xie.h"

extern int yyparse();
/* Fragmentation is bad! So Vartab.h, the functab, the constab and Main.cpp have been consolidated (also, to avoid some nasty issues under Win32) */

#define STACK_SIZE 512
#define LOOKUP 258
#define ARG_LST_SIZE 1024

typedef struct {
	int nempty;  // This is for speed, we just set it to 0 if it can be overwritten
	char varname[5];
	int vartype;
	int i;
	float f;
	char s[STACK_SIZE];

} VARTABLE;

VARTABLE vartab[STACK_SIZE];

char testvarname[5][5];

int vartab_index = 0;     /*Contains the next empty location of the vartab*/
int functab_index = 0;

/* Function prototypes for the vartab*/
void set_var(int id, int i, float f, char s[], int type);
void init_vartab( void );
int insert_var(char * name, int vartype);
int find_var_by_name(char * name);
char * find_varname_by_id(int id);
void print_val(int id);

/* End of vartab stuff */

/* Start of Functab stuff */

typedef struct {
	int nempty;  // This is for speed, we just set it to 0 if it can be overwritten
	char funcname[5];
	int rettype;
	char arglist[ARG_LST_SIZE]; // Not actually an arglist, just a string with the whole function.
} FUNCTABLE;

FUNCTABLE functab[STACK_SIZE];


/* Functab function prototypes */

void set_func(int id, int rettype, char arglist[ARG_LST_SIZE]);
void init_functab( void );
int insert_funct(char * name, int rettype);
int find_func_by_name(char * name);
char * find_funcname_by_id(int id);
int exec_func(int func_id, char arglist); // Returns 1 on success or 0 on failure, and sets error_code to the reason upon an error.

/* End of functab */

#define SSIZE 512

typedef struct {
	int lineno;
	int tok;
} TOK;

//#include "vartab.h"
#include "lex.h"
#include "parser.h"

//#include "lex.cpp"

extern int yylex();
int lineno = 1;

extern "C" int yywrap(void) {
  return 1;
}

char *name[] = {
        "LOOKUP",
	"SETINT",
	"SETFLT",
	"SETSTR",
	"PLUS",
	"MINUS",
	"DIVIDE",
	"TIMES",
	"MODULO",
	"VAR",
	"STRING",
	"I",
	"F",
	"CALL",
	"FUNC",
	"DEFFUNC",
	"IF",
	"OPN_CS",
	"CLS_CS",
	"OPN_PAR",
	"CLS_PAR",
	"BGN_ARR",
	"END_ARR",
	"END_STMT", 		
	"PRINT",
	"ASSIGN",
	"EQUAL",
	"NEQ",
	"LT",
	"GT",
	"LTEQ",
	"GTEQ",
	"AND",
	"OR",
	"INC",
	"DEC",
	"FOR",
	"WHILE",
	"ERR_CODE"
};

int stack_index;
int tok[512];


void main( void )
{
	/* Init */
	init_vartab();
	/* End Init */

	/* Start the lexer */
/*	int i = 1;
	tok[0] = i;

	FILE *yyin = stdin;

	while(tok[i-1] != NULL)
	{
		tok[i] = yylex();
		//line[i] = lineno;
		cout << "TOKEN: " << name[tok[i]-LOOKUP] << endl;
                stack_index = i ;
		i++;
	}

	/* The lexer is done */

	/* Start parsing */
	
	
	
	/* Finished parsing */

	get_conf_data("gian", "", "xie.conf");

	parse:
		yyparse();
	goto parse;

}


void set_var(int id, int i, float f, char s[], int type) // int = 1, float = 2, string = 3
{

		if(type == 1)
			vartab[id].i = (int)i;

		if(type == 2)
			vartab[id].f = (float)f;


		if(type == 3)
		{
			int d = 0;
			while(s[d] != NULL)
			{
				vartab[id].s[d] = s[d];
				d++;
			}
		}
}

void init_vartab( void )
{
	int i;
	for(i = 0; i<STACK_SIZE+1; i++)
	{
		vartab[i].nempty = 0;
	}
}

int insert_var(char * name, int vartype)
{


                vartab[vartab_index].nempty = 1;
		/*vartab[vartab_index].varname = name;*/
                strcpy(vartab[vartab_index].varname , name);
		vartab[vartab_index].vartype = vartype;
             /*   printf("The inserted contains %s" , vartab[vartab_index].varname);*/
                vartab_index++;
              /*  printf("hi\n");
                printf("The inserted at zero contains %s" , vartab[0].varname);   */
                return (vartab_index-1);


/*	int i = 0;

           printf("The 0 loc %d" ,vartab[i].nempty )  ;
	while(vartab[i].nempty != 0)
	{
            printf("the loc he %d %d" , i , vartab[i].nempty);
		i++;
	}


	if(vartab[i].nempty == 0)
	{
		vartab[i].nempty = 1;
		vartab[i].varname = name;
		vartab[i].vartype = vartype;
                return i;
	}*/



}

int find_var_by_name(char * name)
{

	int i;


        for(i = 0 ; i < 3 ; i++)       {
                if(strcmp(vartab[i].varname, name) == 0){

                     printf("The var %s  The location %d \n" , vartab[i].varname , i);
                     return(i);

                 }

        }


/*	while(strcmp(vartab[i].varname, name) != 0)
	{
		i++;
	}

	if(strcmp(vartab[i].varname, name) == 0)
	{
		id = i;
	}

	return id;*/

		return 0;
}

char * find_varname_by_id(int id)
{
	return vartab[id].varname;
}

int det_type(int id)
{
	return vartab[id].vartype;
}

void print_val(int id)
{	
	if(vartab[id].vartype == 1 || vartab[id].vartype == 2 || vartab[id].vartype == 3)
	{
		if(vartab[id].vartype == 1)
		{
			printf("%d", vartab[id].i);
		}

		if(vartab[id].vartype == 2)
		{
			printf("%f", vartab[id].f);
		}

		if(vartab[id].vartype == 3)
		{
			printf("%s", vartab[id].s);
		}
	}

	else {
		printf("Parse error: %s is not valid type, %d", find_varname_by_id(id), vartab[id].vartype);
	}

}

/* Func tab functions */

void set_func(int id, int rettype, char arglist[ARG_LST_SIZE])
{
	functab[id].rettype = rettype;
}

void init_functab( void )
{
	int i;
	for(i = 0; i<STACK_SIZE+1; i++)
	{
		functab[i].nempty = 0;
	}
}

int insert_funct(char * name, int rettype)
{

        vartab[functab_index].nempty = 1;
        strcpy(functab[functab_index].funcname , name);
		functab[functab_index].rettype = rettype;
        functab_index++;
        return (functab_index-1);
}

int find_func_by_name(char * name)
{
	int i;

    for(i = 0 ; i < 3 ; i++)       
	{
		if(strcmp(functab[i].funcname, name) == 0)
		{
			printf("The func %s  The location %d \n" , functab[i].funcname , i);
            
			return(i);

		}

	}

	return 0;
}

char * find_funcname_by_id(int id)
{
	return functab[id].funcname;
}

int exec_func(int func_id, char arglist) // Returns 1 on success or 0 on failure, and sets error_code to the reason upon an error.
{
	// this must be done later...
	return 0;
}